/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminElementInLogTableModel;
import filenet.vw.toolkit.admin.result.VWAdminElementInQueueTableModel;
import filenet.vw.toolkit.admin.result.VWAdminElementInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminElementTableData;
import filenet.vw.toolkit.admin.result.VWAdminElementTableModel;
import filenet.vw.toolkit.admin.result.VWAdminFieldsTableData;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminStatisticsTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWFByElementInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWFByWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWFObjByWOInQueueTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWFObjByWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWOTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import java.util.EventObject;
import java.util.Vector;

public class VWAdminMenuUpdateEvent
extends EventObject {
    private boolean m_nextSet;
    private boolean m_refresh;
    private boolean m_showHideColumns;
    private boolean m_lock;
    private boolean m_manageAttachments;
    private boolean m_manageWFGroups;
    private boolean m_unlock;
    private boolean m_unlockAll;
    private boolean m_save;
    private boolean m_saveAll;
    private boolean m_cancel;
    private boolean m_cancelAll;
    private boolean m_manageTrackers;
    private boolean m_deleteWork;
    private boolean m_terminateWork;
    private boolean m_complete;
    private boolean m_assignReassignWork;
    private boolean m_returnWork;
    private boolean m_recovery;
    private boolean m_selectColumn;
    private boolean m_viewEventLog;
    private boolean m_editFields;
    private boolean m_print;
    private boolean m_outOfOffice;
    private boolean m_exportFile;
    private boolean m_openItem;
    private boolean m_openTracker;
    private boolean m_openStepProcessor;
    private boolean m_infoStack;
    private VWAdminResultTableModelBase m_tableModel = null;
    private VWAdminResultPane m_resultsPane = null;
    private VWTable m_resultsTable = null;
    private int[] m_selectedRows = null;
    private int[] m_selectedCols = null;
    private boolean m_singleCol = false;
    private boolean m_rowSelectionAllowed = false;
    private VWSession m_session = null;
    private VWParticipant m_logonUser = null;

    public VWAdminMenuUpdateEvent(Object source) {
        super(source);
        try {
            if (!(source instanceof VWAdminResultPane)) {
                this.init();
                return;
            }
            this.m_resultsPane = (VWAdminResultPane)source;
            this.m_session = this.m_resultsPane.getSession();
            this.m_logonUser = this.m_resultsPane.getLogonUser();
            this.m_tableModel = this.m_resultsPane.getTableModel();
            this.m_resultsTable = this.m_resultsPane.getResultsTable();
            this.m_selectedRows = this.m_resultsPane.getSelectedRows();
            this.m_selectedCols = this.m_resultsPane.getSelectedCols();
            if (this.m_resultsTable.getRowSelectionAllowed()) {
                this.m_rowSelectionAllowed = true;
            }
            this.m_singleCol = this.m_resultsPane.isSingleColumnSelected();
            this.init();
            if (this.m_resultsTable != null && this.m_resultsTable.getRowCount() > 0) {
                if (this.m_tableModel instanceof VWAdminWOTableModel) {
                    this.initForWorkObjectType();
                } else if (this.m_tableModel instanceof VWAdminElementTableModel) {
                    this.initForElementType();
                } else if (this.m_tableModel instanceof VWAdminStatisticsTableModel) {
                    this.initForStatisticsType();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean getSelectColumn() {
        return this.m_selectColumn;
    }

    public boolean getViewEventLog() {
        return this.m_viewEventLog;
    }

    public boolean getEditFields() {
        return this.m_editFields;
    }

    public boolean getNextSet() {
        if (this.m_tableModel instanceof VWAdminWOTableModel || this.m_tableModel instanceof VWAdminElementTableModel) {
            return this.m_tableModel.hasNext();
        }
        return false;
    }

    public boolean getRefresh() {
        return this.m_refresh;
    }

    public boolean getOpenItem() {
        return this.m_openItem;
    }

    public boolean getOpenTracker() {
        return this.m_openTracker;
    }

    public boolean getOpenStepProcessor() {
        return this.m_openStepProcessor;
    }

    public boolean getPrint() {
        return this.m_print;
    }

    public boolean getShowHideColumns() {
        return this.m_showHideColumns;
    }

    public boolean getManageAttachments() {
        return this.m_manageAttachments;
    }

    public boolean getManageWFGroups() {
        return this.m_manageWFGroups;
    }

    public boolean getLock() {
        return this.m_lock;
    }

    public boolean getUnlock() {
        return this.m_unlock;
    }

    public boolean getUnlockAll() {
        return this.m_unlockAll;
    }

    public boolean getSave() {
        return this.m_save;
    }

    public boolean getSaveAll() {
        return this.m_saveAll;
    }

    public boolean getCancel() {
        return this.m_cancel;
    }

    public boolean getCancelAll() {
        return this.m_cancelAll;
    }

    public boolean getManageTrackers() {
        return this.m_manageTrackers;
    }

    public boolean getDeleteWork() {
        return this.m_deleteWork;
    }

    public boolean getTerminateWork() {
        return this.m_terminateWork;
    }

    public boolean getComplete() {
        return this.m_complete;
    }

    public boolean getAssignReassignWork() {
        return this.m_assignReassignWork;
    }

    public boolean getReturnWork() {
        return this.m_returnWork;
    }

    public boolean getRecovery() {
        return this.m_recovery;
    }

    public boolean getOutOfOffice() {
        return this.m_outOfOffice;
    }

    public boolean getExportFile() {
        return this.m_exportFile;
    }

    public boolean getInformationStack() {
        return this.m_infoStack;
    }

    private void init() {
        this.m_recovery = true;
        this.m_outOfOffice = true;
        this.m_refresh = false;
        this.m_nextSet = false;
        this.m_showHideColumns = false;
        this.m_selectColumn = false;
        this.m_viewEventLog = false;
        this.m_editFields = false;
        this.m_lock = false;
        this.m_manageAttachments = false;
        this.m_manageWFGroups = false;
        this.m_unlock = false;
        this.m_unlockAll = false;
        this.m_save = false;
        this.m_saveAll = false;
        this.m_cancel = false;
        this.m_cancelAll = false;
        this.m_manageTrackers = false;
        this.m_assignReassignWork = false;
        this.m_returnWork = false;
        this.m_deleteWork = false;
        this.m_terminateWork = false;
        this.m_complete = false;
        this.m_openItem = false;
        this.m_openTracker = false;
        this.m_openStepProcessor = false;
        this.m_print = false;
        this.m_exportFile = false;
        this.m_infoStack = false;
        if (this.m_resultsTable != null && this.m_tableModel != null && this.m_resultsTable.getRowCount() > 0) {
            this.m_showHideColumns = true;
            this.m_print = true;
            this.m_exportFile = true;
            if ((this.m_resultsTable.hasFocus() || this.m_resultsTable.getSelectedColumnCount() > 0) && (this.m_tableModel instanceof VWAdminWOTableModel || this.m_tableModel instanceof VWAdminElementInRosterTableModel || this.m_tableModel instanceof VWAdminElementInQueueTableModel)) {
                this.m_viewEventLog = true;
            }
        }
    }

    private void initForWorkObjectType() {
        this.m_unlockAll = this.getIsUnlockAllEnabled();
        this.m_cancelAll = this.getIsCancelAllEnabled();
        this.m_saveAll = this.getIsSaveAllEnabled();
        if (!this.m_rowSelectionAllowed && !this.m_singleCol) {
            return;
        }
        this.m_refresh = this.getIsRefreshEnabled();
        this.m_openItem = this.getIsOpenItemEnabled();
        this.m_openTracker = this.getIsOpenTrackerEnabled();
        this.m_openStepProcessor = this.getIsOpenStepProcessorEnabled();
        this.m_deleteWork = this.getIsDeleteWorkEnabled();
        this.m_terminateWork = this.getIsTerminateWorkEnabled();
        this.m_assignReassignWork = this.getIsAssignReassignWorkEnabled();
        this.m_returnWork = this.getIsReturnWorkEnabled();
        this.m_manageTrackers = this.getIsManageTrackersEnabled();
        if (this.m_tableModel instanceof VWAdminWFObjByWOInRosterTableModel || this.m_tableModel instanceof VWAdminWFObjByWOInQueueTableModel) {
            this.m_complete = this.getIsCompleteWorkEnabled();
            this.m_infoStack = this.getIsInfoStackEnabled();
        }
        if (this.m_singleCol) {
            this.m_selectColumn = true;
        }
        this.m_lock = this.getIsLockEnabled();
        this.m_manageAttachments = this.getIsManageAttachmentsEnabled();
        this.m_manageWFGroups = this.getIsManageWFGroupsEnabled();
        this.m_unlock = this.getIsUnlockEnabled();
        this.m_save = this.getIsSaveEnabled();
        this.m_cancel = this.getIsCancelEnabled();
        this.m_editFields = this.getIsEditFieldsEnabled();
    }

    private void initForElementType() {
        if (!this.m_rowSelectionAllowed && !this.m_singleCol) {
            return;
        }
        this.m_openItem = this.getIsOpenItemEnabled();
        this.m_openTracker = this.getIsOpenTrackerEnabled();
        this.m_openStepProcessor = this.getIsOpenStepProcessorEnabled();
        if (this.m_singleCol) {
            this.m_selectColumn = true;
        }
    }

    private void initForStatisticsType() {
        if (this.m_singleCol) {
            this.m_selectColumn = true;
        }
    }

    private boolean getIsRefreshEnabled() {
        boolean b_enabled = true;
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        if (this.m_logonUser == null) {
            return false;
        }
        if (this.m_selectedRows.length == 0) {
            return false;
        }
        return b_enabled;
    }

    private boolean getIsLockEnabled() {
        boolean b_enabled = false;
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        if (this.m_logonUser == null) {
            return false;
        }
        if (this.m_selectedRows.length == 0) {
            return false;
        }
        try {
            for (int i = 0; i < this.m_selectedRows.length; ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(this.m_selectedRows[i]);
                int lockedStatus = woData.getLockedStatus();
                if (lockedStatus != 3 && lockedStatus != 2) continue;
                b_enabled = true;
                break;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return b_enabled;
    }

    private boolean getIsUnlockEnabled() {
        boolean b_enabled = false;
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        if (this.m_logonUser == null) {
            return false;
        }
        if (this.m_selectedRows.length == 0) {
            return false;
        }
        try {
            for (int i = 0; i < this.m_selectedRows.length; ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(this.m_selectedRows[i]);
                int lockedStatus = woData.getLockedStatus();
                if (lockedStatus != 1) continue;
                b_enabled = true;
                break;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return b_enabled;
    }

    private boolean getIsUnlockAllEnabled() {
        boolean b_enabled = false;
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        if (this.m_logonUser == null) {
            return false;
        }
        try {
            for (int i = 0; i < this.m_resultsTable.getRowCount(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(i);
                int lockedStatus = woData.getLockedStatus();
                if (lockedStatus != 1) continue;
                b_enabled = true;
                break;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return b_enabled;
    }

    private boolean getIsReturnWorkEnabled() {
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        return this.m_logonUser != null;
    }

    private boolean getIsAssignReassignWorkEnabled() {
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        return this.m_logonUser != null;
    }

    private boolean getIsDeleteWorkEnabled() {
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        return this.m_logonUser != null;
    }

    private boolean getIsTerminateWorkEnabled() {
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        return this.m_logonUser != null;
    }

    private boolean getIsManageTrackersEnabled() {
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        return this.m_logonUser != null;
    }

    private boolean getIsCompleteWorkEnabled() {
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        return this.m_logonUser != null;
    }

    private boolean getIsSaveEnabled() {
        boolean b_enabled = false;
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        if (this.m_logonUser == null) {
            return false;
        }
        if (this.m_selectedRows.length == 0) {
            return false;
        }
        try {
            for (int i = 0; i < this.m_selectedRows.length; ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(this.m_selectedRows[i]);
                int lockedStatus = woData.getLockedStatus();
                if (lockedStatus != 1 || !woData.isDirty()) continue;
                b_enabled = true;
                break;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return b_enabled;
    }

    private boolean getIsSaveAllEnabled() {
        boolean b_enabled = false;
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        if (this.m_logonUser == null) {
            return false;
        }
        try {
            for (int i = 0; i < this.m_resultsTable.getRowCount(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(i);
                int lockedStatus = woData.getLockedStatus();
                if (lockedStatus != 1 || !woData.isDirty()) continue;
                b_enabled = true;
                break;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return b_enabled;
    }

    private boolean getIsCancelEnabled() {
        boolean b_enabled = false;
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        if (this.m_logonUser == null) {
            return false;
        }
        if (this.m_selectedRows.length == 0) {
            return false;
        }
        try {
            for (int i = 0; i < this.m_selectedRows.length; ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(this.m_selectedRows[i]);
                int lockedStatus = woData.getLockedStatus();
                if (lockedStatus != 1 || !woData.isDirty()) continue;
                b_enabled = true;
                break;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return b_enabled;
    }

    private boolean getIsCancelAllEnabled() {
        boolean b_enabled = false;
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        if (this.m_logonUser == null) {
            return false;
        }
        try {
            for (int i = 0; i < this.m_resultsTable.getRowCount(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(i);
                int lockedStatus = woData.getLockedStatus();
                if (lockedStatus != 1 || !woData.isDirty()) continue;
                b_enabled = true;
                break;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return b_enabled;
    }

    private boolean getIsManageAttachmentsEnabled() {
        boolean b_enabled = false;
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        if (this.m_logonUser == null) {
            return false;
        }
        if (this.m_selectedRows.length == 0) {
            return false;
        }
        try {
            for (int i = 0; i < this.m_selectedRows.length; ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(this.m_selectedRows[i]);
                int lockedStatus = woData.getLockedStatus();
                if (lockedStatus != 1) {
                    b_enabled = false;
                    break;
                }
                b_enabled = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return b_enabled;
    }

    private boolean getIsManageWFGroupsEnabled() {
        boolean b_enabled = true;
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        if (this.m_logonUser == null) {
            return false;
        }
        return b_enabled;
    }

    private boolean getIsEditFieldsEnabled() {
        boolean b_enabled = false;
        if (this.m_logonUser == null) {
            return false;
        }
        if (!this.m_resultsPane.isSingleColumnSelected()) {
            return false;
        }
        if (this.m_selectedRows.length == 0) {
            return false;
        }
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        int modelColIndex = this.m_resultsPane.getSelectedModelColIndex(this.m_selectedCols[0]);
        if (!this.m_tableModel.isValidColumnToEdit(modelColIndex)) {
            return false;
        }
        Vector v_objects = this.m_resultsPane.getSelectedCellObjects(this.m_selectedRows, modelColIndex);
        if (v_objects == null) {
            return false;
        }
        if (v_objects.size() == 0) {
            return false;
        }
        return this.m_tableModel.isValidFieldDataToEdit((VWAdminFieldsTableData)v_objects.elementAt(0));
    }

    private boolean getIsOpenItemEnabled() {
        boolean b_enabled = false;
        if (this.m_selectedRows.length != 1) {
            return false;
        }
        if (this.m_tableModel instanceof VWAdminWOTableModel) {
            b_enabled = true;
        } else if (this.m_tableModel instanceof VWAdminElementTableModel && !(this.m_tableModel instanceof VWAdminElementInLogTableModel)) {
            b_enabled = true;
        }
        return b_enabled;
    }

    private boolean getIsOpenTrackerEnabled() {
        boolean b_enabled = true;
        if (!this.getIsOpenItemEnabled()) {
            return false;
        }
        return b_enabled;
    }

    private boolean getIsOpenStepProcessorEnabled() {
        boolean b_enabled = false;
        if (!this.getIsOpenItemEnabled()) {
            return false;
        }
        if (this.m_tableModel instanceof VWAdminWFByElementInRosterTableModel || this.m_tableModel instanceof VWAdminWFByWOInRosterTableModel) {
            b_enabled = false;
        } else {
            try {
                String queueName;
                VWSession session;
                VWQueue queue;
                Object woData;
                VWWorkObject wob = null;
                if (this.m_tableModel instanceof VWAdminWOTableModel) {
                    woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(this.m_selectedRows[0]);
                    wob = ((VWAdminWorkObjectTableData)woData).getWob();
                } else if (this.m_tableModel instanceof VWAdminElementTableModel) {
                    woData = (VWAdminElementTableData)this.m_tableModel.getObjectAt(this.m_selectedRows[0]);
                    wob = ((VWAdminElementTableData)woData).getWob();
                }
                String exceptionStr = wob.getLastErrorNumber();
                if (exceptionStr != null && VWStringUtils.compare(exceptionStr, "0") != 0) {
                    return false;
                }
                b_enabled = wob.getIsTracker() ? false : (queue = (session = this.m_resultsPane.getSession()).getQueue(queueName = wob.getCurrentQueueName())).getQueueType() != 3 && !queue.getIsConnectorQueue();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return b_enabled;
    }

    private boolean getIsInfoStackEnabled() {
        if (!(this.m_tableModel instanceof VWAdminWOTableModel)) {
            return false;
        }
        return this.m_logonUser != null;
    }
}

